varying vec2 vtc;

uniform sampler2D tex;
uniform float cutoff;

// The width of the image we are downscaling by 2 (NOT divided by 2!)
uniform float width;

void main(void) 
{
	// TODO: We could use alpha here as well to combine with cutoff...
	
	float d = 0.5 / width;
	
	// Right now we are evaluating at the center point of the LARGE square. I think the code below is correct but how do I know?

	// Box filter (since we have no mipmaps we do it manually)
	vec4 c0 = texture2D(tex, vtc + d * vec2(-1.0,-1.0));
	vec4 c1 = texture2D(tex, vtc + d * vec2( 1.0,-1.0));
	vec4 c2 = texture2D(tex, vtc + d * vec2(-1.0, 1.0));
	vec4 c3 = texture2D(tex, vtc + d * vec2( 1.0, 1.0));
	
	vec4 c  = max((c0+c1+c2+c3)*0.25 - vec4(cutoff,cutoff,cutoff,0.0), vec4(0.0, 0.0, 0.0, 0.0));
	
	gl_FragColor = c * 3.0;
}